program Enumerator;

uses
  System.SysUtils;

type
  TPrzykładowyEnumerator = class
  private
    FTekst: string;
    FIndeks: integer;
  protected
    function GetCurrent: Char; virtual;
  public
    constructor Create(aTekst: string);
    function MoveNext: Boolean;
    property Current: Char read GetCurrent;
  end;

  TPrzykładowaKlasa = class
  private
    FPrzykładowyTekst: string;
    procedure WpiszTekst(const Wartość: string);
  public
    constructor Create(aTekst: string);
    function GetEnumerator: TPrzykładowyEnumerator;
    property Tekst: string read FPrzykładowyTekst write WpiszTekst;
  end;

constructor TPrzykładowyEnumerator.Create(aTekst: string);
begin
  FTekst := aTekst;
end;

function TPrzykładowyEnumerator.GetCurrent: Char;
begin
  Result := FTekst[FIndeks];
end;

function TPrzykładowyEnumerator.MoveNext: Boolean;
begin
  Result := FIndeks < FTekst.Length;
  if Result then
  begin
    Inc(FIndeks);
  end;
end;

constructor TPrzykładowaKlasa.Create(aTekst: string);
begin
  FPrzykładowyTekst := aTekst;
end;

procedure TPrzykładowaKlasa.WpiszTekst(const Wartość: string);
begin
  FPrzykładowyTekst := Wartość;
end;

function TPrzykładowaKlasa.GetEnumerator: TPrzykładowyEnumerator;
begin
  Result := TPrzykładowyEnumerator.Create(FPrzykładowyTekst);
end;

procedure PrzeglądajTekst;
var
  PrzykładowaKlasa: TPrzykładowaKlasa;
  Z: Char;
begin
  PrzykładowaKlasa := TPrzykładowaKlasa.Create('Witaj, świecie!');
  try
    for Z in PrzykładowaKlasa do
    begin
      Write(Z, ',');
    end;
    WriteLn;
  finally
    PrzykładowaKlasa.Free;
  end;
end;

begin
  PrzeglądajTekst;
  ReadLn;
end.
